<?php
// بدء الجلسة
session_start();
require_once '../config/db.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    $stmt = $pdo->prepare('SELECT * FROM users WHERE username = :username OR email = :username LIMIT 1');
    $stmt->execute(['username' => $username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['role'] = $user['role'];
        header('Location: ../admin/dashboard.php');
        exit;
    } else {
        $error = 'اسم المستخدم أو كلمة المرور غير صحيحة';
    }
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .login-container { max-width: 400px; margin: 60px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        .logo { display: block; margin: 0 auto 24px; width: 120px; }
        h2 { color: #EA9218; text-align: center; margin-bottom: 24px; }
        label { color: #3A4750; }
        input[type=text], input[type=password] { width: 100%; padding: 10px; margin: 8px 0 16px; border: 1px solid #EA9218; border-radius: 4px; }
        button { background: #EA9218; color: #fff; border: none; padding: 10px 24px; border-radius: 4px; width: 100%; font-size: 16px; }
        .error { color: #d00; text-align: center; margin-bottom: 12px; }
    </style>
</head>
<body>
    <div class="login-container">
        <img src="../assets/logo.png" alt="شعار الشركة" class="logo">
        <h2>تسجيل الدخول</h2>
        <?php if ($error): ?>
            <div class="error"> <?= $error ?> </div>
        <?php endif; ?>
        <form method="post">
            <label for="username">اسم المستخدم أو البريد الإلكتروني</label>
            <input type="text" name="username" id="username" required>
            <label for="password">كلمة المرور</label>
            <input type="password" name="password" id="password" required>
            <button type="submit">دخول</button>
        </form>
    </div>
</body>
</html>
